
***********************************************************
* ART for All in Eswatini  - Effect on Economic Outcomes   * 
* Author - Janina Steinert                                *
* Date created -- 22 January, 2019                        * 
* Last modified -- 31 July, 2020                          *
***********************************************************

set more off
cd ""


// Outcome 1: Active Time Use

use "C:\Users\ge79jas\Dokumente\Publications\Journal Submissions\eLife\R&R\Active_Timeuse.dta", clear


// Define Treatment Arm

gen AforA = 0
replace AforA  = 1 if SiteCode == "001" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "002" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "003" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "004" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "005" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "006" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "007" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "008" & interview_date >= date("01/01/2016", "DMY")
replace AforA = 1 if SiteCode == "009" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "010" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "011" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "012" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "013" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "014" & interview_date >= date("01/01/2016", "DMY")
tab AforA
tab AforA SiteCode

// Define Period

gen period = .
replace period = 0 if interview_date < date("01/01/2015", "DMY")
replace period = 1 if interview_date >= date("01/01/2015", "DMY") & interview_date < date("01/05/2015", "DMY")
replace period = 2 if interview_date >= date("01/05/2015", "DMY") & interview_date < date("01/09/2015", "DMY")
replace period = 3 if interview_date >= date("01/09/2015", "DMY") & interview_date < date("01/01/2016", "DMY")
replace period = 4 if interview_date >= date("01/01/2016", "DMY") & interview_date < date("01/05/2016", "DMY")
replace period = 5 if interview_date >= date("01/05/2016", "DMY") & interview_date < date("01/09/2016", "DMY")
replace period = 6 if interview_date >= date("01/09/2016", "DMY") & interview_date < date("01/10/2016", "DMY")
replace period = 7 if interview_date >  date("01/10/2016", "DMY")
tab period


// Define Outcome: Active Time Use



/// Break down time by thirds per hour
destring _all, replace

gen act1_1=0
replace act1_1 =1 if _2a_activity>0

gen act1_2=0
replace act1_2 =1 if _2b_activity>0

gen act1_3=0
replace act1_3=1 if _2c_activity>0
 
gen act2_1=0
replace act2_1 =1 if _3a_activity>0

gen act2_2=0
replace act2_2 =1 if _3b_activity>0

gen act2_3=0
replace act2_3=1 if _3c_activity>0

 gen act3_1=0
replace act3_1 =1 if _4a_activity>0

gen act3_2=0
replace act3_2 =1 if _4b_activity>0

gen act3_3=0
replace act3_3=1 if _4c_activity>0

 gen act4_1=0
replace act4_1 =1 if _5a_activity>0

gen act4_2=0
replace act4_2 =1 if _5b_activity>0

gen act4_3=0
replace act4_3=1 if _5c_activity>0


 gen act5_1=0
replace act5_1 =1 if _6a_activity>0

gen act5_2=0
replace act5_2 =1 if _6b_activity>0

gen act5_3=0
replace act5_3=1 if _6c_activity>0

 gen act6_1=0
replace act6_1 =1 if _7a_activity>0

gen act6_2=0
replace act6_2 =1 if _7b_activity>0

gen act6_3=0
replace act6_3=1 if _7c_activity>0
 
gen act7_1=0
replace act7_1 =1 if _8a_activity>0

gen act7_2=0
replace act7_2 =1 if _8b_activity>0

gen act7_3=0
replace act7_3=1 if _8c_activity>0

gen act8_1=0
replace act8_1 =1 if _9a_activity>0

gen act8_2=0
replace act8_2 =1 if _9b_activity>0

gen act8_3=0
replace act8_3=1 if _9c_activity>0

gen act9_1=0
replace act9_1 =1 if _10a_activity>0

gen act9_2=0
replace act9_2 =1 if _10b_activity>0

gen act9_3=0
replace act9_3=1 if _10c_activity>0

gen act10_1=0
replace act10_1 =1 if _11a_activity>0

gen act10_2=0
replace act10_2 =1 if _11b_activity>0

gen act10_3=0
replace act10_3=1 if _11c_activity>0

gen act11_1=0
replace act11_1 =1 if _12a_activity>0

gen act11_2=0
replace act11_2 =1 if _12b_activity>0

gen act11_3=0
replace act11_3=1 if _12c_activity>0

gen act12_1=0
replace act12_1 =1 if _13a_activity>0

gen act12_2=0
replace act12_2 =1 if _13b_activity>0

gen act12_3=0
replace act12_3=1 if _13c_activity>0

gen act13_1=0
replace act13_1 =1 if _14a_activity>0

gen act13_2=0
replace act13_2 =1 if _14b_activity>0

gen act13_3=0
replace act13_3=1 if _14c_activity>0

gen act14_1=0
replace act14_1 =1 if _15a_activity>0

gen act14_2=0
replace act14_2 =1 if _15b_activity>0

gen act14_3=0
replace act14_3=1 if _15c_activity>0
gen act15_1=0
replace act15_1 =1 if _16a_activity>0

gen act15_2=0
replace act15_2 =1 if _16b_activity>0

gen act15_3=0
replace act15_3=1 if _16c_activity>0

gen act16_1=0
replace act16_1 =1 if _17a_activity>0

gen act16_2=0
replace act16_2 =1 if _17b_activity>0

gen act16_3=0
replace act16_3=1 if _17c_activity>0


gen act17_1=0
replace act17_1 =1 if _18a_activity>0

gen act17_2=0
replace act17_2 =1 if _18b_activity>0

gen act17_3=0
replace act17_3=1 if _18c_activity>0

gen act18_1=0
replace act18_1 =1 if _19a_activity>0

gen act18_2=0
replace act18_2 =1 if _19b_activity>0

gen act18_3=0
replace act18_3=1 if _19c_activity>0

gen act19_1=0
replace act19_1 =1 if _20a_activity>0

gen act19_2=0
replace act19_2 =1 if _20b_activity>0

gen act19_3=0
replace act19_3=1 if _20c_activity>0


gen act20_1=0
replace act20_1 =1 if _21a_activity>0

gen act20_2=0
replace act20_2 =1 if _21b_activity>0

gen act20_3=0
replace act20_3=1 if _21c_activity>0


gen act21_1=0
replace act21_1 =1 if _22a_activity>0

gen act21_2=0
replace act21_2 =1 if _22b_activity>0

gen act21_3=0
replace act21_3=1 if _22c_activity>0



gen act22_1=0
replace act22_1 =1 if _23a_activity>0

gen act22_2=0
replace act22_2 =1 if _23b_activity>0

gen act22_3=0
replace act22_3=1 if _23c_activity>0

gen act23_1=0
replace act23_1 =1 if _24a_activity>0

gen act23_2=0
replace act23_2 =1 if _24b_activity>0

gen act23_3=0
replace act23_3=1 if _24c_activity>0

gen act24_1=0
replace act24_1 =1 if _25a_activity>0

gen act24_2=0
replace act24_2 =1 if _25b_activity>0

gen act24_3=0
replace act24_3=1 if _25c_activity>0


egen totalact72= rowtotal(act*), missing
gen activity24= totalact72/3
sum activity24
hist activity24

sum activity24 if AforA==0
sum activity24 if AforA==1  

***********************************************************************
***********************************************************************
***********************************************************************


// Outcome Analysis

 *Basic H and H model with time variable
mixed activity24   i.period  AforA   || SiteCode:, covariance(unstructured)   

// Predict RRs:
mepoisson activity24   i.period  AforA   || SiteCode:,  covariance(unstructured)   irr 

margins, dydx(AforA)


  ** Thompson Model 
mixed activity24  i.period  AforA    ||  SiteCode: period, covariance(unstructured)    
  
// Predict RRs:
menbreg activity24  i.period  AforA    ||  SiteCode: period, covariance(unstructured)   irr  difficult
  
 
 // Adding Controls
 
// Sex
gen female = .
replace female=1 if _1_sex == 1
replace female = 0 if _1_sex == 2

// age
rename _2_age age 

// marital status
gen married = 0
replace married = 1 if _3_married_status == 1

// education
 destring _1_highest_grade, replace
 rename _1_highest_grade education
recode education (14=1)


// Grand Mean centring
sum female 
gen female_c = female-r(mean)
sum married 
gen married_c = married -r(mean)
sum age 
gen age_c = age -r(mean)
sum education
gen education_c = education -r(mean)


 *Basic H and H model with time variable
mixed activity24   i.period  i.AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured)   

// Predict RRs
menbreg activity24   i.period  i.AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured)   irr

margins, dydx(AforA)

// add permuted p values

gen nonmiss = 1 if AforA<.

bysort SiteCode period nonmiss: gen t1 = _N
bysort  SiteCode period AforA: gen t2 = _N

count if t1 != t2 & AforA< .

list if t1 != t2 &  AforA< .


drop if t1 != t2 &  AforA< .


swpermute _b[1.AforA], cluster(SiteCode) period(period) intervention(AforA) seed(123) reps(500) : ///
menbreg activity24   i.period  i.AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured)   irr



  ** Thompson Model 
mixed activity24  i.period  AforA   female_c married_c age_c education_c ||  SiteCode: period, covariance(unstructured)    
  
 // Predict RRs
menbreg activity24  i.period  AforA   female_c married_c age  education_c ||  SiteCode: period,  irr difficult  
 
 // Add restricted cubic splines for education and age
 
 mkspline agesp = age, cubic displayknots
 mkspline educationsp = education, cubic displayknots
 

 *Basic H and H model with time variable
mixed activity24   i.period  AforA  female_c married_c agesp* educationsp* || SiteCode:, covariance(unstructured)   
  ** Thompson Model 
mixed activity24  i.period  AforA   female_c married_c agesp* educationsp*||  SiteCode: period, covariance(unstructured)    
  
*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************


// Outcome 2: Income-Generating Time Use


use "C:\Users\ge79jas\Dokumente\Publications\Journal Submissions\eLife\R&R\Productive_Timeuse.dta", clear
**
**
**
// Define Treatment Arm

gen AforA = 0
replace AforA  = 1 if SiteCode == "001" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "002" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "003" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "004" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "005" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "006" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "007" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "008" & interview_date >= date("01/01/2016", "DMY")
replace AforA = 1 if SiteCode == "009" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "010" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "011" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "012" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "013" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "014" & interview_date >= date("01/01/2016", "DMY")
tab AforA
tab AforA SiteCode

// Define Period

gen period = .
replace period = 0 if interview_date < date("01/01/2015", "DMY")
replace period = 1 if interview_date >= date("01/01/2015", "DMY") & interview_date < date("01/05/2015", "DMY")
replace period = 2 if interview_date >= date("01/05/2015", "DMY") & interview_date < date("01/09/2015", "DMY")
replace period = 3 if interview_date >= date("01/09/2015", "DMY") & interview_date < date("01/01/2016", "DMY")
replace period = 4 if interview_date >= date("01/01/2016", "DMY") & interview_date < date("01/05/2016", "DMY")
replace period = 5 if interview_date >= date("01/05/2016", "DMY") & interview_date < date("01/09/2016", "DMY")
replace period = 6 if interview_date >= date("01/09/2016", "DMY") & interview_date < date("01/10/2016", "DMY")
replace period = 7 if interview_date >  date("01/10/2016", "DMY")
tab period



 
***************************************************************************************
// Define Productive Time Use
// This is the time used for income generation activities

gen prodh1=0

local varlist "_2a_activity _2b_activity _2c_activity"
foreach var of local varlist {
	replace prodh1=1 if `var'>0 &`var' <=3
	 
}
 
 
gen prodh2=0

local varlist "_3a_activity _3b_activity _3c_activity"
foreach var of local varlist {
	replace prodh2=1 if `var'>0 &`var' <=3
	 
}
 
 gen prodh3=0

local varlist "_4a_activity _4b_activity _4c_activity"
foreach var of local varlist {
	replace prodh3=1 if `var'>0 &`var' <=3
 
}
 
 
 gen prodh4=0

local varlist "_5a_activity _5b_activity _5c_activity"
foreach var of local varlist {
	replace prodh4=1 if `var'>0 &`var' <=3
	 
}

gen prodh5=0

local varlist "_6a_activity _6b_activity _6c_activity"
foreach var of local varlist {
	replace prodh5=1 if `var'>0 &`var' <=3
	 
}

gen prodh6=0

local varlist "_7a_activity _7b_activity _7c_activity"
foreach var of local varlist {
	replace prodh6=1 if `var'>0 &`var' <=3
	 
}

gen prodh7=0

local varlist "_8a_activity _8b_activity _8c_activity"
foreach var of local varlist {
	replace prodh7=1 if `var'>0 &`var' <=3
	 
}


gen prodh8=0

local varlist "_9a_activity _9b_activity _9c_activity"
foreach var of local varlist {
	replace prodh8=1 if `var'>0 &`var' <=3
	 
}


gen prodh9=0

local varlist "_10a_activity _10b_activity _10c_activity"
foreach var of local varlist {
	replace prodh9=1 if `var'>0 &`var' <=3
	 
}

gen prodh10=0

local varlist "_11a_activity _11b_activity _11c_activity"
foreach var of local varlist {
	replace prodh10=1 if `var'>0 &`var' <=3
	 
}

gen prodh11=0

local varlist "_12a_activity _12b_activity _12c_activity"
foreach var of local varlist {
	replace prodh11=1 if `var'>0 &`var' <=3
 
}

gen prodh12=0

local varlist "_13a_activity _13b_activity _13c_activity"
foreach var of local varlist {
	replace prodh12=1 if `var'>0 &`var' <=3
 
}
gen prodh13=0

local varlist "_14a_activity _14b_activity _14c_activity"
foreach var of local varlist {
	replace prodh13=1 if `var'>0 &`var' <=3
	 
}

gen prodh14=0

local varlist "_15a_activity _15b_activity _15c_activity"
foreach var of local varlist {
	replace prodh14=1 if `var'>0 &`var' <=3
 
}

gen prodh15=0

local varlist "_16a_activity _16b_activity _16c_activity"
foreach var of local varlist {
	replace prodh15=1 if `var'>0 &`var' <=3
	 
}

gen prodh16=0

local varlist "_17a_activity _17b_activity _17c_activity"
foreach var of local varlist {
	replace prodh16=1 if `var'>0 &`var' <=3
	 
}

gen prodh17=0

local varlist "_18a_activity _18b_activity _18c_activity"
foreach var of local varlist {
	replace prodh17=1 if `var'>0 &`var' <=3
	 
}

gen prodh18=0

local varlist "_19a_activity _19b_activity _19c_activity"
foreach var of local varlist {
	replace prodh18=1 if `var'>0 &`var' <=3
	 
}

gen prodh19=0

local varlist "_20a_activity _20b_activity _20c_activity"
foreach var of local varlist {
	replace prodh19=1 if `var'>0 &`var' <=3
	 
}

gen prodh20=0

local varlist "_21a_activity _21b_activity _21c_activity"
foreach var of local varlist {
	replace prodh20=1 if `var'>0 &`var' <=3
	 
}

gen prodh21=0

local varlist "_22a_activity _22b_activity _22c_activity"
foreach var of local varlist {
	replace prodh21=1 if `var'>0 &`var' <=3
	 
}


gen prodh22=0

local varlist "_23a_activity _23b_activity _23c_activity"
foreach var of local varlist {
	replace prodh22=1 if `var'>0 &`var' <=3
 
}


gen prodh23=0

local varlist "_24a_activity _24b_activity _24c_activity"
foreach var of local varlist {
	replace prodh23=1 if `var'>0 &`var' <=3
	 
}

gen prodh24=0

local varlist "_25a_activity _25b_activity _25c_activity"
foreach var of local varlist {
	replace prodh24=1 if `var'>0 &`var' <=3
	 
}

egen totalprod24 = rowtotal(prodh*), missing

sum totalprod24 
hist totalprod24


sum totalprod24 if AforA==0


sum totalprod24 if AforA==1


***********************************************************************
***********************************************************************
***********************************************************************


// Outcome Analysis


// Skewed Distribution and arguably a count variable, i.e. neg. binomial regression

 *Basic H and H model with time variable
menbreg totalprod24  i.period  AforA   || SiteCode:, covariance(unstructured)   irr
 
 ** Thompson Model 
menbreg totalprod24  i.period  AforA    ||  SiteCode: period,     irr difficult
  
 
 // Adding Controls
 
 

// Sex
gen female = .
replace female=1 if _1_sex == 1
replace female = 0 if _1_sex == 2

// age
rename _2_age age 

// marital status
gen married = 0
replace married = 1 if _3_married_status == 1

// education
 destring _1_highest_grade, replace
 rename _1_highest_grade education
recode education (14=1)


// Grand Mean centring
sum female 
gen female_c = female-r(mean)
sum married 
gen married_c = married -r(mean)
sum age 
gen age_c = age -r(mean)
sum education
gen education_c = education -r(mean)


 *Basic H and H model with time variable
menbreg totalprod24  i.period  AforA female_c married_c age_c education_c   || SiteCode:, covariance(unstructured)   irr
 
 margins, dydx(AforA)
 
 ** Thompson Model 
menbreg totalprod24  i.period  AforA  female_c married_c age_c education_c   ||  SiteCode: period,     irr difficult

*******************************************************************************
*******************************************************************************

 
 // Add restricted cubic splines for education and age
 

 *Basic H and H model with time variable
menbreg totalprod24  i.period  AforA female_c married_c age* education*  || SiteCode:, covariance(unstructured)   irr
 
 ** Thompson Model 
menbreg totalprod24  i.period  AforA  female_c married_c age* education*   ||  SiteCode: period,     irr difficult

  
// add permuted p values

gen nonmiss = 1 if AforA<.

bysort SiteCode period nonmiss: gen t1 = _N
bysort  SiteCode period AforA: gen t2 = _N

count if t1 != t2 & AforA< .

list if t1 != t2 &  AforA< .

drop if t1 != t2 &  AforA< .

swpermute _b[1.AforA], cluster(SiteCode) period(period) intervention(AforA) seed(123) reps(1000): ///
menbreg totalprod24  i.period  i.AforA female_c married_c age_c education_c   || SiteCode:, covariance(unstructured)   irr


*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************
 

 
// Outcome 3: Employment

use "C:\Users\ge79jas\Dokumente\Publications\Journal Submissions\eLife\R&R\Employment.dta", clear

 // Define Treatment Arm

gen AforA = 0
replace AforA  = 1 if SiteCode == "001" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "002" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "003" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "004" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "005" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "006" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "007" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "008" & interview_date >= date("01/01/2016", "DMY")
replace AforA = 1 if SiteCode == "009" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "010" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "011" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "012" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "013" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "014" & interview_date >= date("01/01/2016", "DMY")
tab AforA
tab AforA SiteCode

// Define Period
gen period = .
replace period = 0 if interview_date < date("01/01/2015", "DMY")
replace period = 1 if interview_date >= date("01/01/2015", "DMY") & interview_date < date("01/05/2015", "DMY")
replace period = 2 if interview_date >= date("01/05/2015", "DMY") & interview_date < date("01/09/2015", "DMY")
replace period = 3 if interview_date >= date("01/09/2015", "DMY") & interview_date < date("01/01/2016", "DMY")
replace period = 4 if interview_date >= date("01/01/2016", "DMY") & interview_date < date("01/05/2016", "DMY")
replace period = 5 if interview_date >= date("01/05/2016", "DMY") & interview_date < date("01/09/2016", "DMY")
replace period = 6 if interview_date >= date("01/09/2016", "DMY") & interview_date < date("01/10/2016", "DMY")
replace period = 7 if interview_date >  date("01/10/2016", "DMY")
tab period



mvdecode _all, mv(9999 = .a) // missings
destring _all, replace


***********************************************

// Define Employment

gen incomegen=0
replace incomegen =1 if _1_currently_work<5  
replace incomegen=. if _1_currently_work==.

// formal employment only
gen formal= 0
replace formal =1 if _1_currently_work==1
replace formal =. if _1_currently_work==.


// informal employment only
gen informal= 0
replace informal =1 if  _1_currently_work==2 | _1_currently_work==3 | _1_currently_work==4  
 replace informal=. if _1_currently_work==.
 
 ********************************************** **********************************************
 ********************************************** **********************************************

 //Outcome Analysis  

 *Basic H and H model with time variable
melogit incomegen  i.period  AforA   || SiteCode:,   or difficult

// Predicting RRs:
meglm incomegen  i.period  i.AforA  || SiteCode:,    fam(poisson) link(log) vce(robust) irr
  
  ** Thompson Model 
melogit incomegen   i.period  AforA    ||  SiteCode: period,     or difficult
  
 margins, dydx(AforA)
 
// Predicting RRs:
meglm incomegen  i.period  AforA  || SiteCode:period,    fam(poisson) link(log)   vce(robust) irr difficult
 
 // Adding Controls
  

// Sex
gen female = .
replace female=1 if _1_sex == 1
replace female = 0 if _1_sex == 2

// age
rename _2_age age 

// marital status
gen married = 0
replace married = 1 if _3_married_status == 1

// education
 destring _1_highest_grade, replace
 rename _1_highest_grade education
recode education (14=1)


// Grand Mean centring
sum female 
gen female_c = female-r(mean)
sum married 
gen married_c = married -r(mean)
sum age 
gen age_c = age -r(mean)
sum education
gen education_c = education -r(mean)


 *Basic H and H model with time variable
meologit incomegen  i.period i.AforA  female_c married_c age_c education_c  || SiteCode:,   or difficult




// Predicting RRs:
meglm incomegen  i.period i.AforA  female_c married_c age_c education_c   || SiteCode:,    fam(poisson) link(log) vce(robust) irr

 margins, dydx(AforA)
 

  ** Thompson Model 
meologit incomegen   i.period  AforA  female_c married_c age_c education_c   ||  SiteCode: period,     or difficult


// Predicting RRs:
meglm incomegen  i.period  AforA  female_c married_c age_c education_c   || SiteCode: period,    fam(poisson) link(log) vce(robust) irr difficult

// Disaggregating by employment type

 
 *Basic H and H model with time variables
meologit formal  i.period  AforA   || SiteCode:,   or difficult

  ** Thompson Model 
meologit formal   i.period  AforA    ||  SiteCode: period,     or difficult


 *Basic H and H model with control variables
meologit formal  i.period  AforA  female_c married_c age_c education_c || SiteCode:,   or difficult
  
  ** Thompson Model  
meologit formal   i.period  AforA   female_c married_c age_c education_c ||  SiteCode: period,     or difficult


***


 *Basic H and H model 
meologit informal  i.period  AforA   || SiteCode:,   or difficult
  ** Thompson Model 
meologit informal   i.period  AforA    ||  SiteCode: period,     or difficult


 *Basic H and H model with control variable
meologit informal  i.period  AforA  female_c married_c age_c education_c || SiteCode:,   or difficult


** Thompson Model
meologit informal   i.period  AforA   female_c married_c age_c education_c ||  SiteCode: period,     or difficult

// Check whether time on ART explains time effect

// Date first knew about HIV+ status (MM/YYYY)
gen temp_date = _5_dt_HIV
replace temp_date = "07"+substr(_5_dt_HIV, -5, .) if substr(_5_dt_HIV, 1, 2) == "99" // Assigns midyear (July) to all observations with missing months
replace temp_date = "" if substr(_5_dt_HIV, -4, .) == "9999" // Assigns "" to all observations with missing year
replace temp_date = "2007" if substr(_5_dt_HIV, -4, .) == "2207" // Corrects data entry mistake 
gen date_HIV_positive = date(temp_date, "MY")
format %td date_HIV_positive
drop temp_date


// Date first attended ART clinic (MM/YYYY)
gen temp_date = _6_dt_ART_clinic
replace temp_date = "07"+substr(_6_dt_ART_clinic, -4, .) if substr(_6_dt_ART_clinic, 1, 2) == "99" // Assigns midyear (July) to all observations with missing months
replace temp_date = "" if substr(_6_dt_ART_clinic, -4, .) == "9999" // Assigns "" to all observations with missing year
replace temp_date = "2015" if substr(_6_dt_ART_clinic, -4, .) == "1015" // Corrects data entry mistake
replace temp_date = "2014" if substr(_6_dt_ART_clinic, -4, .) == "0214" // Corrects data entry mistake
replace temp_date = "2013" if substr(_6_dt_ART_clinic, -4, .) == "3013" // Corrects data entry mistake
gen date_1st_ART_clinic = date(temp_date, "MY")
format %td date_1st_ART_clinic
drop temp_date


// Date first started treatment with ARVs (MM/YYYY)
gen temp_date = _8_dt_received_ART
replace temp_date = "07"+substr(_8_dt_received_ART, -4, .) if substr(_8_dt_received_ART, 1, 2) == "99" // Assigns midyear (July) to all observations with missing months
replace temp_date = "" if substr(_8_dt_received_ART, -4, .) == "9999" // Assigns "" to all observations with missing year
replace temp_date = "2015" if substr(_8_dt_received_ART, -4, .) == "2915" // Corrects data entry mistake
gen date_ART_start = date(temp_date, "MY")
format %td date_ART_start
drop temp_date
 
 
// Months since HIV Diagnosis
gen months_since_HIV_dx = (interview_date - date_HIV_positive)/30
replace months_since_HIV_dx = . if months_since_HIV_dx < 0

// Duration on ARVs (in months)
gen months_since_ART_start = (interview_date - date_ART_start)/30
replace months_since_ART_start = . if months_since_ART_start < 0
  

//Heterogeneity Analyis



 *Basic H and H model with time variable
meologit informal  i.period  AforA##c.months_since_ART_start female_c married_c age_c education_c  || SiteCode:,   or difficult
  
  ** Thompson Model 
meologit incomegen   i.period  AforA  female_c married_c age_c education_c   ||  SiteCode: period,     or difficult


// add permuted p values

gen nonmiss = 1 if AforA<.

bysort SiteCode period nonmiss: gen t1 = _N
bysort  SiteCode period AforA: gen t2 = _N

count if t1 != t2 & AforA< .

list if t1 != t2 &  AforA< .

drop if t1 != t2 &  AforA< .

swpermute _b[1.AforA], cluster(SiteCode) period(period) intervention(AforA) seed(123) reps(1000): ///
meglm incomegen  i.period##i.AforA  female_c married_c age_c education_c   || SiteCode:,    fam(poisson) link(log) vce(robust) irr


  
*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************
 

 
// Outcome 4: Assets

use "C:\Users\ge79jas\Dokumente\Publications\Journal Submissions\eLife\R&R\Assets.dta", replace

// Define Treatment Arm

gen AforA = 0
replace AforA  = 1 if SiteCode == "001" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "002" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "003" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "004" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "005" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "006" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "007" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "008" & interview_date >= date("01/01/2016", "DMY")
replace AforA = 1 if SiteCode == "009" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "010" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "011" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "012" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "013" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "014" & interview_date >= date("01/01/2016", "DMY")
tab AforA
tab AforA SiteCode

// Define Period

gen period = .
replace period = 0 if interview_date < date("01/01/2015", "DMY")
replace period = 1 if interview_date >= date("01/01/2015", "DMY") & interview_date < date("01/05/2015", "DMY")
replace period = 2 if interview_date >= date("01/05/2015", "DMY") & interview_date < date("01/09/2015", "DMY")
replace period = 3 if interview_date >= date("01/09/2015", "DMY") & interview_date < date("01/01/2016", "DMY")
replace period = 4 if interview_date >= date("01/01/2016", "DMY") & interview_date < date("01/05/2016", "DMY")
replace period = 5 if interview_date >= date("01/05/2016", "DMY") & interview_date < date("01/09/2016", "DMY")
replace period = 6 if interview_date >= date("01/09/2016", "DMY") & interview_date < date("01/10/2016", "DMY")
replace period = 7 if interview_date >  date("01/10/2016", "DMY")
tab period

 **********************************************
// Outcome 6: Assets
***********************************************
destring _1_drinking_water_household, replace
tab  _1_drinking_water_household, miss

gen drinkingwater=0
replace drinkingwater=1 if _1_drinking_water_household<3
replace drinkingwater=. if  _1_drinking_water_household==.

destring _2_toilet_household, replace
tab _2_toilet_household

gen toiletvip=0
replace toiletvip=1 if _2_toilet_household==3
replace toiletvip=. if  _2_toilet_household==.
tab toiletvip

destring _3_fuel_household, replace
tab _3_fuel_household

gen fuel=0
replace fuel =1 if _3_fuel_household <4
replace fuel =1 if _3_fuel_household ==6
replace fuel =1 if _3_fuel_household ==7
replace fuel =. if _3_fuel_household ==.
tab fuel

destring _4_roof_household, replace
tab _4_roof_household

gen roof=0
replace roof=1 if _4_roof_household >8 & _4_roof_household <14
replace roof=. if  _4_roof_household==. 
tab roof

destring _5_floor_household, replace
tab  _5_floor_household 

gen floor=0
replace floor =1 if  _5_floor_household >2 & _5_floor_household<14
replace floor =. if  _5_floor_household ==.
tab floor

 destring _6_walls_household, replace force
 tab _6_walls_household
 
 gen walls=0
 replace walls = 1 if  _6_walls_household>7
  replace walls = . if  _6_walls_household==.
  tab walls
  
 
  destring _7_homestead_ownership,replace
  gen ownhome=0
  replace ownhome=1 if _7_homestead_ownership==1
    replace ownhome=. if _7_homestead_ownership==.
	tab ownhome
	
	destring _8_refrigerator, replace
  gen fridge=0
  replace fridge=1 if _8_refrigerator==1
    replace fridge=. if _8_refrigerator==.

	 destring _8_n_refrigerator, replace
	 gen fridgemore=0
	 replace fridgemore=1 if _8_n_refrigerator>1 & _8_n_refrigerator !=.
	 
	destring _9_washing_machine, replace
  gen washing=0
  replace washing=1 if _9_washing_machine==1
    replace washing=. if _9_washing_machine==.
	
	 destring _9_n_washing_machine, replace
	 gen washingmore=0
	 replace washingmore=1 if _9_n_washing_machine>1 & _9_n_washing_machine !=.
	 
	
	destring _10_sewing_machine, replace
	gen sewing=0
	replace sewing = 1 if _10_sewing_machine==1
	replace sewing=. if _10_sewing_machine==.
	
	 destring _10_n_sewing_machine, replace
	 gen sewingmore=0
	 replace sewingmore=1 if _10_n_sewing_machine>1 & _10_n_sewing_machine!=.
	 
	
	
	destring _11_flatscreen_TV, replace
	gen flatscreen=0
	replace flatscreen = 1 if _11_flatscreen_TV==1
	replace flatscreen=. if _11_flatscreen_TV==.
tab flatscreen

destring _11_n_flatscreen_TV, replace force
	 gen flatmore=0
	 replace flatmore=1 if _11_n_flatscreen_TV>1 & _11_n_flatscreen_TV!=.
	 
	
	destring _12_ordinary_TV, replace
	gen TV=0
	replace TV=1 if _12_ordinary_TV==1
	replace _12_ordinary_TV=. if _12_ordinary_TV==.

	destring   _12_n_ordinary_TV, replace  
	 gen TVmore=0
	 replace TVmore=1 if _12_n_ordinary_TV>1 & _12_n_ordinary_TV!=.
	 
	destring _13_video_dvd, replace
	gen video=0
	replace video=1 if _13_video_dvd==1
	replace video=. if _13_video_dvd==.
	
		destring   _13_n_video_dvd, replace   force
	 gen videomore=0
	 replace videomore=1 if _13_n_video_dvd>1 & _13_n_video_dvd!=.
	 
	 
		destring _14_satellite_dish, replace
	gen satellite=0
	replace satellite=1 if _14_satellite_dish==1
	replace satellite=. if _14_satellite_dish==.
	
	destring   _14_n_satellite_dish, replace   force
	 gen satmore=0
	 replace satmore=1 if _14_n_satellite_dish>1 & _14_n_satellite_dish!=.
	 	  
	destring _15_radio, replace
	gen radio=0
	replace radio=1 if _15_radio==1
	replace radio =. if _15_radio==.
	
	destring  _15_n_radio, replace   force
	 gen radiomore=0
	 replace radiomore=1 if _15_n_radio>1 & _15_n_radio!=.
	 
	 
	destring _16_computer, replace
	gen pc=0
	replace pc=1 if _16_computer==1
	replace pc=. if _16_computer==.
	
		
	destring  _16_n_computer, replace   force
	 gen pcmore=0
	 replace pcmore=1 if _16_n_computer>1 & _16_n_computer!=.
	 
	 	
	destring _17_stereo, replace
	gen stereo=0
	replace stereo=1 if _17_stereo==1
	replace stereo=. if _17_stereo==.
	
		
	destring _17_n_stereo, replace   force
	 gen stereomore=0
	 replace stereomore=1 if _17_n_stereo>1 & _17_n_stereo!=.
	 
	 			
	destring _18_camera, replace
	gen camera=0
	replace camera=1 if _18_camera==1
	replace camera=. if _18_camera==.
	
	
	destring _18_n_camera, replace   force
	 gen cammore=0
	 replace cammore=1 if _18_n_camera>1 & _18_n_camera!=.
	 
	 			
				
	destring _19_air_conditioner, replace
	gen ac=0
	replace ac=1 if _19_air_conditioner==1
	replace ac=. if _19_air_conditioner==.
	
	destring _19_n_air_conditioner, replace   force
	 gen acmore=0
	 replace acmore=1 if _19_n_air_conditioner>1 & _19_n_air_conditioner!=.
	 	 			
	
	destring _20_ordinary_cell_phone, replace
	gen cell=0
	replace cell=1 if _20_ordinary_cell_phone==1
	replace cell=. if _20_ordinary_cell_phone==.
	
		
	destring 	_20_n_ordinary_cell_phone, replace   force
	 gen cellmore=0
	 replace cellmore=1 if _20_n_ordinary_cell_phone>1 & _20_n_ordinary_cell_phone!=.
	 	 			
	
	destring _21_smart_phone, replace
	gen smart=0
	replace smart=1 if _21_smart_phone==1
	replace smart=. if _21_smart_phone==.
	
	destring _21_n_smart_phone, replace   force
	 gen smartmore=0
	 replace smartmore=1 if _21_n_smart_phone>1 & _21_n_smart_phone!=.
	 	 				
	
	destring _22_cement_mixer, replace
	gen mixer=0
	replace mixer=1 if _22_cement_mixer==1
	replace mixer=. if _22_cement_mixer==.
	
		destring _22_n_cement_mixer, replace   force
	 gen mixmore=0
	 replace mixmore=1 if _22_n_cement_mixer>1 & _22_n_cement_mixer!=.
	 	 				
	
	
	destring _23_clock_watch, replace
	gen clock=0
	replace clock=1 if _23_clock_watch==1
	replace clock=. if _23_clock_watch==.
	
	destring _23_n_clock_watch, replace   force
	 gen clockmore=0
	 replace clockmore=1 if _23_n_clock_watch>1 & _23_n_clock_watch!=.
	 	 				
	destring _24_mattress, replace
	gen mattress=0
	replace mattress=1 if _24_mattress==1
	replace mattress=. if _24_mattress==.
	
	
	destring _24_n_mattress, replace   force
	 gen matmore=0
	 replace matmore=1 if _24_n_mattress>1 & _24_n_mattress!=.
	
	destring _25_pressure_cooker, replace
	gen cooker=0
	replace cooker=1 if _25_pressure_cooker==1
	replace cooker=. if _25_pressure_cooker==.
	
	
	destring _25_n_pressure_cooker, replace   force
	 gen cookmore=0
	 replace cookmore=1 if _25_n_pressure_cooker>1 & _25_n_pressure_cooker!=.
	
	
	destring _26_sofa, replace
	gen sofa=0
	replace sofa=1 if _26_sofa==1
	replace sofa=. if _26_sofa==.
	
	
	destring _26_n_sofa, replace   force
	 gen sofamore=0
	 replace sofamore=1 if _26_n_sofa>1 & _26_n_sofa!=.
	
	
	
	destring _27_bed_cot, replace
	gen bed=0 
	replace bed=1 if _27_bed_cot==1
	replace bed=. if _27_bed_cot==.
	
		destring _27_n_bed_cot, replace   force
	 gen bedmore=0
	 replace bedmore=1 if _27_n_bed_cot>1 & _27_n_bed_cot!=.
	
	
		destring _28_table, replace
	gen table=0
	replace table =1 if _28_table==1
	replace table =. if _28_table==.
	
	
		destring _28_n_table, replace   force
	 gen tabmore=0
	 replace tabmore=1 if _28_n_table>1 & _28_n_table!=.
	
	
	destring _29_electric_fan, replace
	gen fan=0
	replace fan=1 if _29_electric_fan==1
	replace fan=. if _29_electric_fan==.
	
	
		destring _29_n_electric_fan, replace   force
	 gen fanmore=0
	 replace fanmore=1 if _29_n_electric_fan>1 & _29_n_electric_fan!=.
	
	destring _30_stove, replace
	gen stove=0
	replace stove =1 if _30_stove==1
	replace stove=. if _30_stove==.
	
	
		destring _30_n_stove, replace   force
	 gen stovemore=0
	 replace stovemore=1 if _30_n_stove>1 & _30_n_stove!=.
	
	destring _31_bicycle, replace
	gen bike=0
	replace bike=1 if _31_bicycle==1
	replace bike=. if _31_bicycle==.
		
		destring _31_n_bicycle, replace   force
	 gen bikemore=0
	 replace bikemore=1 if _31_n_bicycle>1 & _31_n_bicycle!=.
	
		
	destring _32_motorcycle, replace
	gen motor=0
	replace motor=1 if _32_motorcycle==1
	replace motor=. if _32_motorcycle==.
	
	destring _32_n_motorcycle, replace   force
	 gen motormore=0
	 replace motormore=1 if _32_n_motorcycle>1 & _32_n_motorcycle!=.
	 
	destring _33_car, replace
	gen car=0
	replace car=1 if _33_car==1
	replace car=. if _33_car==.
	
	destring _33_n_car, replace   force
	 gen carmore=0
	 replace carmore=1 if _33_n_car>1 & _33_n_car!=.
	
	destring _34_kombi, replace
	gen kombi=0
	replace kombi=1 if _34_kombi==1
	replace kombi=. if _34_kombi==.
	
		destring  _34_n_kombi, replace   force
	 gen kombimore=0
	 replace kombimore=1 if  _34_n_kombi>1 &  _34_n_kombi!=.
	 
	destring _35a_land_agriculture, replace
	gen land=0
	replace land=1 if _35a_land_agriculture==1
	replace land=. if _35a_land_agriculture==.
	
	destring _36a_own_livestock, replace
	gen livestock=0
	replace livestock=1 if _36a_own_livestock==1
	replace livestock=. if _36a_own_livestock==. // do  not use this as it is filter variable
	
	destring _36b_own_cattle, replace
	gen cattle=0
	replace cattle =1 if _36b_own_cattle==1 
	
		destring  _36b_n_cattle, replace   force
	 gen cattlemore=0
	 replace cattlemore=1 if _36b_n_cattle>1 &  _36b_n_cattle!=.
	 
	
	destring _36c_own_milk_cows, replace
	gen cow=0
	replace cow=1 if _36c_own_milk_cows==1
		
		destring  _36c_n_milk_cows, replace   force
	 gen cowmore=0
	 replace cowmore=1 if _36c_n_milk_cows>1 &  _36c_n_milk_cows!=.
	
	destring _36d_own_horses,replace
	gen horse=0
	replace horse=1 if _36d_own_horses==1
	
	destring _36d_n_horses, replace   force
	 gen horsemore=0
	 replace horsemore=1 if _36d_n_horses>1 &  _36d_n_horses!=.
	
	
	destring _36e_own_goats, replace
	gen goat=0
	replace goat=1 if _36e_own_goats==1
	
	destring _36e_n_goats, replace   force
	 gen goatmore=0
	 replace goatmore=1 if _36e_n_goats>1 &  _36e_n_goats!=.
		
	
	destring _36f_own_sheep, replace
	gen sheep=0
	replace sheep=1 if _36f_own_sheep==1
	
	destring _36f_n_sheep, replace   force
	 gen sheepmore=0
	 replace sheepmore=1 if _36f_n_sheep>1 &  _36f_n_sheep!=.
	
	destring _36g_own_chickens, replace
	gen chicken=0
	replace chicken=1 if _36g_own_chickens==1
	
	destring _36g_n_chickens, replace   force
	 gen chickmore=0
	 replace chickmore=1 if _36g_n_chickens>1 &  _36g_n_chickens!=.
	
	destring _36h_own_pigs, replace
	gen pig=0
	replace pig=1 if _36h_own_pigs==1
	
	destring _36h_n_pigs, replace force
	 gen pigmore=0
	 replace pigmore=1 if _36h_n_pigs>1 &  _36h_n_pigs!=.
	
	factor drinkingwater toiletvip fuel roof floor walls ownhome fridge   washing ///
	sewing flatscreen TV video satellite radio pc stereo camera ac cell smart mixer clock ///
	mattress cooker sofa bed table fan stove bike motor car kombi land  cow cattle ///
	horse goat sheep chicken pig
	
	screeplot // looks like more eigenfaktors
	
	
	factor drinkingwater toiletvip fuel roof floor walls ownhome fridge  washing ///
	sewing flatscreen TV video satellite radio pc stereo camera ac cell smart mixer clock ///
	mattress cooker sofa bed table fan stove bike motor car kombi land  cow cattle ///
	horse goat sheep chicken pig, factor(3) blanks (.3)
	
	// not all  items seem to be a good fit
	// should we only keep those that load above .3?
	
	// Simple sum score:
	
	
egen assetsum=rowtotal(drinkingwater toiletvip fuel roof floor walls ownhome fridgemore ///
 washingmore washing sewing sewingmore sewingmore flatscreen flatmore TV TVmore video ///
 videomore satellite satmore radio radiomore pc pcmore stereo stereomore camera cammore ac ///
 acmore cell cellmore smart smartmore mixer mixmore clock clockmore mattress matmore cooker ///
 cookmore sofa bed sofamore bedmore table fan tabmore fanmore stove stovemore bike bikemore ///
 motor motormore car carmore kombi kombimore land livestock cattle cattlemore cow cowmore ///
 horse goat horsemore goatmore sheep chicken pig sheepmore chickmore pigmore), missing
	
hist assetsum
	
//  pca-weighted index

pca drinkingwater toiletvip fuel roof floor walls ownhome fridge   washing ///
	sewing flatscreen TV video satellite radio pc stereo camera ac cell smart mixer clock ///
	mattress cooker sofa bed table fan stove bike motor car kombi land  cow cattle ///
	horse goat sheep chicken pig
	
	
predict asset_pca, score

hist asset_pca
 
// Outcome Analysis



 *Basic H and H model with time variable
mixed assetsum  i.period  AforA   || SiteCode:, covariance(unstructured)   


menbreg assetsum  i.period  AforA   || SiteCode:, covariance(unstructured)   irr
  
  ** Thompson Model 
mixed assetsum  i.period  AforA    ||  SiteCode: period, covariance(unstructured)    
 menbreg assetsum  i.period  AforA    ||  SiteCode: period, covariance(unstructured)    irr difficult
  
 
 // Adding Controls
  
// Sex
gen female = .
replace female=1 if _1_sex == 1
replace female = 0 if _1_sex == 2

// age
rename _2_age age 

// marital status
gen married = 0
replace married = 1 if _3_married_status == 1

// education
 destring _1_highest_grade, replace
 rename _1_highest_grade education
recode education (14=1)


// Grand Mean centring
sum female 
gen female_c = female-r(mean)
sum married 
gen married_c = married -r(mean)
sum age 
gen age_c = age -r(mean)
sum education
gen education_c = education -r(mean)


 *Basic H and H model with time variable
 
mixed assetsum  i.period  i.AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured)

menbreg assetsum  i.period  i.AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured) irr 
// add permuted p values

gen nonmiss = 1 if AforA<.

bysort SiteCode period nonmiss: gen t1 = _N
bysort  SiteCode period AforA: gen t2 = _N

count if t1 != t2 & AforA< .

list if t1 != t2 &  AforA< .

drop if t1 != t2 &  AforA< .

swpermute _b[1.AforA], cluster(SiteCode) period(period) intervention(AforA) seed(222) reps(1000): ///
mepoisson assetsum period  i.AforA female_c married_c age_c education_c   || SiteCode:, difficult iterate(500) 
  

  
  ** Thompson Model 
mixed assetsum   i.period  AforA   female_c married_c age_c education_c ||  SiteCode: period, covariance(unstructured)    
 menbreg assetsum   i.period  AforA   female_c married_c age  education_c ||  SiteCode: period,  covariance(unstructured)        irr difficult
   
 
 // Add restricted cubic splines for education and age
 
 mkspline agesp = age, cubic displayknots
 mkspline educationsp = education, cubic displayknots
 

 *Basic H and H model with time variable
mixed asset_pca i.period  AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured)   
menbreg   asset_pca i.period  AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured)   irr
  ** Thompson Model 
mixed asset_pca  i.period  AforA   female_c married_c  age_c education_c||  SiteCode: period, covariance(unstructured)    
  
*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************
 

 
// Outcome 5: Household Expenditures
// we have information on "normal month" and past 12 months

// Summarise information for normal month

use "C:\Users\ge79jas\Dokumente\Publications\Journal Submissions\eLife\R&R", replace



// Define Treatment Arm

gen AforA = 0
replace AforA  = 1 if SiteCode == "001" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "002" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "003" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "004" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "005" & interview_date >= date("01/09/2015", "DMY")
replace AforA = 1 if SiteCode == "006" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "007" & interview_date >= date("01/05/2016", "DMY")
replace AforA = 1 if SiteCode == "008" & interview_date >= date("01/01/2016", "DMY")
replace AforA = 1 if SiteCode == "009" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "010" & interview_date >= date("01/09/2016", "DMY")
replace AforA = 1 if SiteCode == "011" & interview_date >= date("01/10/2016", "DMY")
replace AforA = 1 if SiteCode == "012" & interview_date >= date("01/05/2015", "DMY")
replace AforA = 1 if SiteCode == "013" & interview_date >= date("01/01/2015", "DMY")
replace AforA = 1 if SiteCode == "014" & interview_date >= date("01/01/2016", "DMY")
tab AforA
tab AforA SiteCode

gen period = .
replace period = 0 if interview_date < date("01/01/2015", "DMY")
replace period = 1 if interview_date >= date("01/01/2015", "DMY") & interview_date < date("01/05/2015", "DMY")
replace period = 2 if interview_date >= date("01/05/2015", "DMY") & interview_date < date("01/09/2015", "DMY")
replace period = 3 if interview_date >= date("01/09/2015", "DMY") & interview_date < date("01/01/2016", "DMY")
replace period = 4 if interview_date >= date("01/01/2016", "DMY") & interview_date < date("01/05/2016", "DMY")
replace period = 5 if interview_date >= date("01/05/2016", "DMY") & interview_date < date("01/09/2016", "DMY")
replace period = 6 if interview_date >= date("01/09/2016", "DMY") & interview_date < date("01/10/2016", "DMY")
replace period = 7 if interview_date >  date("01/10/2016", "DMY")
tab period

// Define Expenditure Outcome

destring _1_groceries_month, force replace
rename   _1_groceries_month exp_food

destring _2_rent_month, force replace
rename _2_rent_month exp_rent

 destring _2_rent_12mos, force replace
rename _2_rent_12mos exp_rent12

destring _3_water_month, force replace
rename _3_water_month exp_water

destring _4_electricity_month, force replace
rename _4_electricity_month exp_electricity

destring _5_fuel_month, force replace
rename _5_fuel_month exp_fuel

destring _6_telephone_month, force replace
rename _6_telephone_month exp_phone

destring _7_schooling_month, force replace
rename _7_schooling_month exp_school


destring _8_airtime_week, force replace
mvdecode _8_airtime_week, mv(9999=.a) // this is weekly, multiply by for to get monthly expenditures
gen exp_airtime= _8_airtime_week*4
 
 
destring  _9_hire_purchase_month, force replace
rename _9_hire_purchase_month exp_hirepur


destring _10_clothing_month, force replace
rename _10_clothing_month exp_clothes


destring _11_transportation_month, force replace
rename _11_transportation_month exp_transport


destring _12_vehicle_month, force replace
rename _12_vehicle_month exp_vehicle


destring _13_church_month, force replace
rename _13_church_month exp_church


destring _14_outside_people_month, force replace
rename _14_outside_people_month exp_outside


destring _15_funerals_nonhousehold_month, force replace
rename _15_funerals_nonhousehold_month exp_funeral

destring _17_insurance_month, force replace
rename _17_insurance_month exp_insurance


destring _18_toiletries_month, force replace
rename _18_toiletries_month exp_toiletries

destring _19_charities_month, force replace
rename _19_charities_month exp_charity

destring _20_entertainment_month, force replace
rename _20_entertainment_month exp_entertain

destring _21_other_month, force replace
rename _21_other_month exp_other

mvdecode _all, mv(9999 = .) // missings
sum exp_food exp_rent exp_water exp_electricity exp_fuel exp_phone exp_school exp_airtime ///
exp_hirepur exp_clothes exp_transport  exp_vehicle exp_church exp_outside exp_funeral  ///
 exp_insurance  exp_toiletries exp_charity exp_entertain exp_other


// Possible outliers/unrealistic values:  14400 lilangeli for monthly schooling expenditures and  15000 lilangeli for funeral (this might be true though)

clonevar exp_school_CLEAN = exp_school
recode exp_school_CLEAN (14400=.)

clonevar exp_funeral_CLEAN = exp_funeral
recode exp_funeral_CLEAN (15000=.)

// Also include two variables that were only measured for the year (here devided by 12)


destring _22_large_purchases_12mos, force replace
rename _22_large_purchases_12mos exp12_large
gen exp_large = exp12_large/12


destring _16_funerals_household_12mos, force replace
rename _16_funerals_household_12mos exp12_funeral2
gen exp_funeralhh= exp12_funeral2/12

// if Info on past month was missing I imputed info from past 12 months divided by 12

egen totalexp_month=rowtotal(exp_food exp_rent exp_water exp_electricity exp_fuel ///
exp_phone exp_school   exp_airtime  exp_hirepur exp_clothes exp_transport ///
exp_vehicle exp_church exp_outside exp_funeral  exp_insurance exp_toiletries ///
exp_charity exp_entertain exp_other exp_funeralhh exp_large), miss 

 
sum totalexp_month
hist totalexp_month


egen totalexp_month_C=rowtotal(exp_food exp_rent exp_water exp_electricity exp_fuel ///
exp_phone exp_school_CLEAN exp_airtime  exp_hirepur exp_clothes exp_transport ///
exp_vehicle exp_church exp_outside exp_funeral_CLEAN  exp_insurance exp_toiletries ///
exp_charity exp_entertain exp_other exp_funeralhh exp_large), miss  

recode  totalexp_month_C(0=.)

hist totalexp_month_C


// Outcome Analysis

***********************************************************************

 *Basic H and H model with time variable
menbreg totalexp_month_C   i.period  AforA   || SiteCode:, covariance(unstructured)   irr

  ** Thompson Model 
menbreg totalexp_month_C  i.period  AforA    ||  SiteCode: period, covariance(unstructured)   irr difficult  
  
 
 // Adding Controls
 

// Sex
gen female = .
replace female=1 if _1_sex == "1"
replace female = 0 if _1_sex == "2"

// age
rename _2_age age 

// marital status
gen married = 0
replace married = 1 if _3_married_status == "1"

// education
 destring _1_highest_grade, replace
 rename _1_highest_grade education
recode education (14=1)


// Grand Mean centring
sum female 
gen female_c = female-r(mean)
sum married 
gen married_c = married -r(mean)
sum age 
gen age_c = age -r(mean)
sum education
gen education_c = education -r(mean)


 *Basic H and H model with time variable
menbreg totalexp_month_C   i.period  AforA   female_c married_c age_c education_c  || SiteCode:, covariance(unstructured)   irr

margins, dydx(AforA)

**3. Inflate expenditures to 2011 constant prices
/* change CPI_"year" to survey year */
dis   -105.8289  /1.2762789

dis  -289.0427/1.2762789

dis  77.38498/1.2762789
*** 4. Convert income to 2011 constant international dollars
dis -82.919885/4.0490688

dis -226.47299/4.0490688

dis 60.633283/4.0490688

  ** Thompson Model 
menbreg totalexp_month_C  i.period  AforA   female_c married_c age_c education_c   ||  SiteCode: period, covariance(unstructured)   irr difficult  
  
  
 
 // Add restricted cubic splines for education and age
 
 mkspline agesp = age, cubic displayknots
 mkspline educationsp = education, cubic displayknots
 
  *Basic H and H model with time variable
menbreg totalexp_month_C   i.period  AforA   female_c married_c age* education*  || SiteCode:, covariance(unstructured)   irr


// add permuted p values

gen nonmiss = 1 if AforA<.

bysort SiteCode period nonmiss: gen t1 = _N
bysort  SiteCode period AforA: gen t2 = _N

count if t1 != t2 & AforA< .

list if t1 != t2 &  AforA< .

drop if t1 != t2 &  AforA< .

swpermute _b[1.AforA], cluster(SiteCode) period(period) intervention(AforA) seed(123) reps(1000): ///
menbreg totalexp_month_C   i.period  i.AforA   female_c married_c age_c education_c  || SiteCode:, covariance(unstructured)   irr


  ** Thompson Model 
menbreg totalexp_month_C  i.period  AforA   female_c married_c age* education* ||  SiteCode: period, covariance(unstructured)   irr difficult  
  
 
  
*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************

*******************************************************************************
*******************************************************************************
 
// Impute the expenditure variable

 // Adding Employment variable 
 
 use "expenditures_IMPUTE.dta", clear
merge 1:1 StudyID using "maxart_employment.dta", force
tab _merge // inspect merger
drop if Survey_ID=="S002"
 drop if Survey_ID=="S003"
 
 // This is the set of variables used for MI: 

 mdesc totalexp_month_C   period  AforA   female married age education assetsum months_since_ART_start months_since_HIV_dx   incomegen
 
 mi set mlong
 
 mi misstable summarize totalexp_month_C   period  AforA   female married age education assetsum months_since_ART_start months_since_HIV_dx totalprod24 incomegen
 
 mi misstable patterns totalexp_month_C   period  AforA   female married age education assetsum months_since_ART_start months_since_HIV_dx totalprod24 incomegen
 
 pwcorr totalexp_month_C   period  AforA   female married age education assetsum months_since_ART_start months_since_HIV_dx totalprod24 incomegen
 
 // check whether any of those predict missingness:
 
 gen exp_flag=1
replace exp_flag=0 if totalexp_month_C==.

reg exp_flag period  AforA   female married age education assetsum months_since_ART_start months_since_HIV_dx totalprod24 incomegen
 //month on ART and since HIV not very predictive, but assetsome, education, and incomegen is
 
 mi register imputed  totalexp_month_C 
 
 mi impute chained (nbreg) totalexp_month_C  =       age education incomegen female married  assetsum  , add(100) rseed (1010) force
 
 
 mi estimate, cmdok: menbreg totalexp_month_C   i.period  AforA   female_c married_c age_c education_c ||  SiteCode: , covariance(unstructured) difficult
  
 
 use trace1,clear

describe


reshape wide *mean *sd, i(iter) j(m)
tsset iter
tsline totalexp_month_C_mean1, name(mice1,replace)legend(off) ytitle("Mean of Total Expenditures")

tsline totalexp_month_C_mean*, name(mice1,replace)legend(off) ytitle("Mean of Read") xaxis(0 (1) )


****************


//Re-do main analysis with 7 clusters instead of 14

gen pair=0
replace pair=1 if SiteCode==6 |SiteCode==13
replace pair=2 if SiteCode==1 |SiteCode==12
replace pair=3 if SiteCode==4 |SiteCode==5
replace pair=4 if SiteCode==8 |SiteCode==14
replace pair=5 if SiteCode==2 |SiteCode==7
replace pair=6 if SiteCode==9 |SiteCode==10
replace pair=7 if SiteCode==3 |SiteCode==11


menbreg activity24   i.period  i.AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured)   irr
menbreg activity24   i.period  i.AforA  female_c married_c age_c education_c || pair:, covariance(unstructured)   irr

menbreg totalprod24  i.period  AforA female_c married_c age* education*  || SiteCode:, covariance(unstructured)   irr
 menbreg totalprod24  i.period  AforA female_c married_c age* education*  || pair:, covariance(unstructured)   irr
 

meglm incomegen  i.period i.AforA  female_c married_c age_c education_c   || SiteCode:,    fam(poisson) link(log) vce(robust) irr
meglm incomegen  i.period i.AforA  female_c married_c age_c education_c   || pair:,    fam(poisson) link(log) vce(robust) irr

menbreg totalexp_month_C   i.period  i.AforA   female_c married_c age_c education_c  || SiteCode:, covariance(unstructured)   irr
menbreg totalexp_month_C   i.period  i.AforA   female_c married_c age_c education_c  || pair:,  covariance(unstructured) irr


menbreg assetsum  i.period  i.AforA  female_c married_c age_c education_c || SiteCode:, covariance(unstructured) irr 
menbreg assetsum  i.period  i.AforA  female_c married_c age_c education_c || pair:,  irr 
